/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPage;
import com.agricraft.agricraft.client.ClientUtil;
import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.item.journal.EmptyPage;
import com.agricraft.agricraft.common.item.journal.FrontPage;
import com.agricraft.agricraft.common.item.journal.GeneticsPage;
import com.agricraft.agricraft.common.item.journal.GrowthReqsPage;
import com.agricraft.agricraft.common.item.journal.IntroductionPage;
import com.agricraft.agricraft.common.item.journal.MutationsPage;
import com.agricraft.agricraft.common.item.journal.PlantPage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class JournalItem
extends class_1792 {
    public JournalItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (player.method_21751()) {
            return class_1271.method_22430((Object)stack);
        }
        if (level.field_9236) {
            ClientUtil.openJournalScreen(player, usedHand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.field_9236) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = context.method_8041();
        class_2586 class_25862 = context.method_8045().method_8321(context.method_8037());
        if (class_25862 instanceof SeedAnalyzerBlockEntity) {
            SeedAnalyzerBlockEntity seedAnalyzer = (SeedAnalyzerBlockEntity)class_25862;
            if (seedAnalyzer.hasJournal()) {
                return class_1269.field_5811;
            }
            class_1799 remaining = seedAnalyzer.insertJournal(heldItem);
            heldItem.method_7939(remaining.method_7947());
            return class_1269.field_21466;
        }
        return super.method_7884(context);
    }

    public class_1799 method_7854() {
        class_1799 stack = new class_1799((class_1935)this);
        return stack;
    }

    public static void researchPlant(class_1799 journal, class_2960 plantId) {
        class_2487 tag = journal.method_7948();
        class_2519 idTag = class_2519.method_23256((String)plantId.toString());
        if (tag.method_10545("plants")) {
            class_2499 plants = tag.method_10554("plants", 8);
            if (!plants.contains((Object)idTag)) {
                plants.add((Object)idTag);
            }
        } else {
            class_2499 plants = new class_2499();
            plants.add((Object)idTag);
            tag.method_10566("plants", (class_2520)plants);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"agricraft.tooltip.journal", (Object[])new Object[]{JournalItem.getResearchedPlants(stack)}).method_27692(class_124.field_1080));
    }

    public static JournalData getJournalData(class_1799 journal) {
        return new Data(journal);
    }

    public static int getResearchedPlants(class_1799 journal) {
        class_2487 tag = journal.method_7969();
        if (tag == null || !tag.method_10545("plants")) {
            return 0;
        }
        return tag.method_10554("plants", 8).size();
    }

    public static class Data
    implements JournalData {
        private final List<class_2960> plants = new ArrayList<class_2960>();
        private final List<JournalPage> pages = new ArrayList<JournalPage>();

        public Data(class_1799 journalStack) {
            class_2487 tag = journalStack.method_7969();
            if (tag != null && tag.method_10545("plants")) {
                class_2499 list = tag.method_10554("plants", 8);
                for (class_2520 plantTag : list) {
                    class_2960 plantId = new class_2960(plantTag.method_10714());
                    if (!AgriApi.getPlant(plantId).isPresent()) continue;
                    this.plants.add(plantId);
                }
            }
            this.plants.sort(Comparator.comparing(class_2960::toString));
            this.initializePages();
        }

        public void initializePages() {
            this.pages.clear();
            this.pages.add(new FrontPage());
            this.pages.add(new IntroductionPage());
            this.pages.add(new GeneticsPage());
            this.pages.add(new GrowthReqsPage());
            for (class_2960 plant : this.plants) {
                PlantPage plantPage = new PlantPage(plant, this.plants);
                this.pages.add(plantPage);
                List<List<class_2960>> mutations = plantPage.getMutationsOffPage();
                int size = mutations.size();
                if (size <= 0) continue;
                int remaining = size;
                int from = 0;
                int to = Math.min(remaining, 18);
                while (remaining > 0) {
                    this.pages.add(new MutationsPage(mutations.subList(from, to)));
                    from = to;
                    to = from + Math.min(remaining -= to - from, 18);
                }
            }
        }

        @Override
        public JournalPage getPage(int index) {
            if (0 <= index && index < this.pages.size()) {
                return this.pages.get(index);
            }
            return new EmptyPage();
        }

        @Override
        public int size() {
            return this.pages.size();
        }

        @Override
        public List<class_2960> getDiscoveredSeeds() {
            return this.plants;
        }
    }
}

